import summary from 'rollup-plugin-summary'
import { terser } from 'rollup-plugin-terser'
import resolve from '@rollup/plugin-node-resolve'
import replace from '@rollup/plugin-replace'
import styles from 'rollup-plugin-styles'
import del from 'rollup-plugin-delete'

import buildIndexFile from './build-index-file-rollup-plugin'

export default {
    input: 'src/index.js',
    output: {
        dir: 'build',
        format: 'esm',
        entryFileNames: 'bundle-[hash].js',
        assetFileNames: '[name]-[hash][extname]',
    },
    onwarn(warning) {
        if (warning.code !== 'THIS_IS_UNDEFINED') {
            console.error(`(!) ${warning.message}`)
        }
    },
    plugins: [
        del({ targets: 'build/*' }),
        replace({ 'Reflect.decorate': 'undefined', preventAssignment: true }),
        resolve(),
        terser({
            ecma: 2016,
            module: true,
            warnings: true,
            mangle: {
                properties: {
                    regex: /^__/,
                },
            },
        }),
        summary(),
        styles({
            minimize: true,
        }),
        buildIndexFile(),
    ],
}
