import { html, css } from 'lit'

import { url } from '../core/qrcg-router'
import { t } from '../core/translate'
import { QrcgCheckoutPage } from './qrcg-checkout-page'

export class QrcgCheckoutCancelled extends QrcgCheckoutPage {
    static styles = [
        super.styles,
        css`
            :host {
                display: block;
            }
        `,
    ]

    renderTitle() {
        return t`Your payment has been cancelled.`
    }

    renderPage() {
        return html`
            <p>
                ${t`You have not been charged, you can resubscribe from`}
                <a href="${url('/pricing-plans')}"> ${t`here`}. </a>
            </p>
            <p>
                ${t`Or you can go back to the`}
                <a href=${url('/')}> ${t`home page`}.</a>
            </p>
        `
    }
}

customElements.define('qrcg-checkout-cancelled', QrcgCheckoutCancelled)
