import { LitElement, html, css } from 'lit'

export class QrcgCheckoutPage extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
                padding: 1rem;
            }

            h1 {
                display: flex;
                min-height: 3rem;
                align-items: center;
            }

            a {
                color: var(--primary-0);
                text-decoration: none;
            }

            .container {
                max-width: 800px;
                margin: auto;
            }

            .loader-container {
                display: flex;
                align-items: center;
                padding-top: 1rem;
            }

            qrcg-loader {
                margin: auto;
            }

            .page-container {
                line-height: 1.8;
            }
        `,
    ]

    renderTitle() {}

    renderPage() {}

    renderLoader() {
        return html`
            <div class="loader-container">
                <qrcg-loader></qrcg-loader>
            </div>
        `
    }

    render() {
        return html`
            <qrcg-box class="container">
                <h1>${this.renderTitle()}</h1>
                <div class="page-container">${this.renderPage()}</div>
            </qrcg-box>
        `
    }
}
