import { LitElement, html, css } from 'lit'

import '../core/qrcg-route'

import './qrcg-checkout'

import './qrcg-checkout-cancelled'

import './qrcg-checkout-stripe-success'

import './qrcg-checkout-offline-payment-received'

export class QrcgCheckoutRouter extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    static async boot() {
        while (!document.body) {
            await new Promise((resolve) => setTimeout(resolve, 50))
        }

        document.body.appendChild(new QrcgCheckoutRouter())
    }

    render() {
        return html`
            <qrcg-route route="/checkout$">
                <template>
                    <qrcg-checkout></qrcg-checkout>
                </template>
            </qrcg-route>

            <qrcg-route route="/checkout/cancelled">
                <template>
                    <qrcg-checkout-cancelled></qrcg-checkout-cancelled>
                </template>
            </qrcg-route>

            <qrcg-route route="/checkout/stripe/success">
                <template>
                    <qrcg-checkout-stripe-success></qrcg-checkout-stripe-success>
                </template>
            </qrcg-route>

            <qrcg-route route="/checkout/offline-payment-received">
                <template>
                    <qrcg-checkout-offline-payment-received></qrcg-checkout-offline-payment-received>
                </template>
            </qrcg-route>
        `
    }
}

customElements.define('qrcg-checkout-router', QrcgCheckoutRouter)

QrcgCheckoutRouter.boot()
