import { css, html } from 'lit'

import { QrcgDashboardForm } from '../dashboard/qrcg-dashboard-form'

import '../ui/qrcg-input'

import '../ui/qrcg-select'

import '../ui/qrcg-balloon-selector'

import '../ui/qrcg-markdown-input'
import { Config } from '../core/qrcg-config'
import { t } from '../core/translate'

export class QrcgContentBlocksForm extends QrcgDashboardForm {
    static get styles() {
        return [
            super.styles,
            css`
                .section-title {
                    font-weight: normal;
                    border-bottom: 2px solid var(--gray-1);
                    padding-bottom: 0.5rem;
                    margin-bottom: 1rem;
                }

                .input-title {
                    display: inline-block;
                    width: 150px;
                }

                qrcg-balloon-selector {
                    /* flex-direction: column; */
                }
            `,
        ]
    }
    constructor() {
        super({
            apiBaseRoute: 'content-blocks',
        })
    }

    renderFormFields() {
        return html`
            <qrcg-input name="title" placeholder="${t`Block title`}"
                >${t`Title`}</qrcg-input
            >

            <qrcg-select name="position">
                <span slot="label">${t`Position`}</span>

                ${Config.get('content-manager.positions').map((position) => {
                    return html`<option value=${position}>${position}</option>`
                })}
            </qrcg-select>

            <qrcg-input name="sort_order" placeholder="${t`Default is 0`}">
                ${t`Sort order`}
                <span slot="instructions">
                    ${t`Controls the order of each block in the selected position.
                    E.g block with sort order set to 1 will be
                    rendered before block with sort order set to
                    2.`}
                </span>
            </qrcg-input>

            <qrcg-markdown-input name="content">
                ${t`Content`}
            </qrcg-markdown-input>

            <h2 class="section-title">${t`Appearance`}</h2>

            <qrcg-balloon-selector
                name="title_alignment"
                .options=${[
                    {
                        name: 'Left',
                        value: 'left',
                    },
                    {
                        name: 'Center',
                        value: 'center',
                    },

                    {
                        name: 'Right',
                        value: 'right',
                    },
                ]}
            >
                <span class="input-title">${t`Title alignment`}</span>
            </qrcg-balloon-selector>

            <qrcg-balloon-selector
                name="content_alignment"
                .options=${[
                    {
                        name: t('Left'),
                        value: 'left',
                    },
                    {
                        name: t('Center'),
                        value: 'center',
                    },

                    {
                        name: t('Right'),
                        value: 'right',
                    },
                ]}
            >
                <span class="input-title"> ${t`Content alignment`} </span>
            </qrcg-balloon-selector>

            <qrcg-color-picker name="title_color">
                <span class="input-title">${t`Title color`}</span>
            </qrcg-color-picker>

            <qrcg-color-picker name="content_color">
                <span class="input-title">${t`Content color`}</span>
            </qrcg-color-picker>

            <qrcg-color-picker name="background_color">
                <span class="input-title">${t`Background color`}</span>
            </qrcg-color-picker>

            <qrcg-input name="margin"> ${t`Margin`} </qrcg-input>

            <qrcg-input name="padding"> ${t`Padding`} </qrcg-input>
        `
    }
}
customElements.define('qrcg-content-blocks-form', QrcgContentBlocksForm)
