import { QRCGDashboardList } from '../dashboard/qrcg-dashboard-list'

export class QrcgContentBlocksList extends QRCGDashboardList {
    constructor() {
        super({
            baseRoute: 'content-blocks',
            singularRecordName: 'Content Blocks',
            frontendFormUrl: null,
        })
    }

    static listColumns = [
        { key: 'title', label: 'Title' },
        { key: 'position', label: 'Position' },
        { key: 'sort_order', label: 'Sort order' },
        { key: 'created_at', label: 'Created' },
        { key: 'actions', label: 'Actions', width: '7rem' },
    ]

    searchPlaceholder() {
        return 'By title or position'
    }
}

customElements.define('qrcg-content-blocks-list', QrcgContentBlocksList)
