export const isEmpty = (subject) => {
    if (subject instanceof File) {
        return false
    }

    if (subject === null) {
        return true
    }

    if (typeof subject === 'undefined') {
        return true
    }

    if (typeof subject === 'string') {
        return subject.trim().length === 0
    }

    // handles objects and arrays alike
    if (typeof subject === 'object') {
        return Object.keys(subject).reduce(
            (acc, key) => acc && isEmpty(subject[key]),
            true
        )
    }

    if (typeof subject === 'number') {
        return subject === 0
    }

    return false
}

export const debounce = (cb, ms = 300) => {
    let timer
    return (...args) => {
        clearTimeout(timer)
        timer = setTimeout(() => {
            cb.apply(this, args)
        }, ms)
    }
}

export const queryParam = (name) => {
    const params = new Proxy(new URLSearchParams(window.location.search), {
        get: (searchParams, prop) => searchParams.get(prop),
    })

    return params[name]
}

export const loadStoredJson = (key) => {
    try {
        return JSON.parse(localStorage[key])
    } catch {
        return null
    }
}

export const nullOrUndefined = (value) => {
    return typeof value === 'undefined' || value === null
}

export const storeJson = (data, key) => {
    localStorage[key] = JSON.stringify(data)
}

export function capitalize(str) {
    return str.replace(/\b\w/g, (m) => m.toUpperCase())
}

export function kebabCase(str) {
    return str.toLowerCase().replace(/ /g, '-')
}
export function studlyCase(str) {
    return titleCase(str).replace(/ /g, '')
}

export function titleCase(str) {
    return capitalize(
        str
            .replace(/-|_/g, ' ')
            .replace(/[A-Z]/g, (m) => ' ' + m)
            .toLowerCase()
    )
}

export function random(min, max) {
    min = Math.ceil(min)
    max = Math.floor(max)
    return Math.floor(Math.random() * (max - min + 1)) + min
}

export function isFunction(param) {
    return typeof param === 'function'
}

export function Deferred() {
    this.isResolved = false
    this.isRejected = false
    this.isConsumed = false
    this.promise = new Promise((resolve, reject) => {
        this.reject = (params) => {
            this.isRejected = true
            this.isConsumed = true
            reject(params)
        }
        this.resolve = (params) => {
            resolve(params)
            this.isResolved = true
            this.isConsumed = true
        }
    })
}

export function isPrimitive(val) {
    return val !== Object(val)
}

export function equals(obj, another) {
    return JSON.stringify(obj) === JSON.stringify(another)
}

export function only(obj, keys) {
    if (!obj) return

    return keys.reduce((result, key) => {
        result[key] = obj[key]
        return result
    }, {})
}

export function rgbToHex({ r, g, b }) {
    const rgb = (r << 16) | (g << 8) | (b << 0)
    return '#' + (0x1000000 + rgb).toString(16).slice(1)
}

export function hexToRgb(hex) {
    var result = /^#?([a-f\d]{2})([a-f\d]{2})([a-f\d]{2})$/i.exec(hex)
    return result
        ? {
              r: parseInt(result[1], 16),
              g: parseInt(result[2], 16),
              b: parseInt(result[3], 16),
          }
        : null
}

/** Noop function to get sytax highlighting to work */
export const styled = (strings, ...rest) => {
    return strings
        .map((str, i) => {
            return str + (rest[i] ? rest[i] : '')
        })
        .join('')
}

export const get = (...params) => {
    try {
        return eval(`params[0].${params[1]}`)
    } catch (error) {
        return undefined
    }
}

export function pxToRem(px) {
    return px / parseFloat(getComputedStyle(document.documentElement).fontSize)
}

export function remToPx(rem) {
    return rem * parseFloat(getComputedStyle(document.documentElement).fontSize)
}

export function hash(str, seed = 0) {
    // https://stackoverflow.com/a/52171480

    let h1 = 0xdeadbeef ^ seed,
        h2 = 0x41c6ce57 ^ seed
    for (let i = 0, ch; i < str.length; i++) {
        ch = str.charCodeAt(i)
        h1 = Math.imul(h1 ^ ch, 2654435761)
        h2 = Math.imul(h2 ^ ch, 1597334677)
    }
    h1 =
        Math.imul(h1 ^ (h1 >>> 16), 2246822507) ^
        Math.imul(h2 ^ (h2 >>> 13), 3266489909)
    h2 =
        Math.imul(h2 ^ (h2 >>> 16), 2246822507) ^
        Math.imul(h1 ^ (h1 >>> 13), 3266489909)
    return 4294967296 * (2097151 & h2) + (h1 >>> 0)
}

export function iPhoneSafari() {
    return !!navigator.userAgent.match('iPhone OS')
}

export function parentMatches(node, parentSelector) {
    do {
        if (node.nodeType == Node.DOCUMENT_FRAGMENT_NODE) {
            node = node.getRootNode().host
        }

        if (node.matches && node.matches(parentSelector)) {
            return node
        }

        node = node.parentNode
    } while (node)

    return null
}
export function generateUniqueID(idLength) {
    return [...Array(idLength).keys()]
        .map(() => Math.random().toString(36).substr(2, 1))
        .join('')
}

export function ucfirst(string) {
    return string[0].toUpperCase() + string.substring(1)
}

// https://stackoverflow.com/a/13382873/2407522
export function getScrollbarWidth() {
    // Creating invisible container
    const outer = document.createElement('div')
    outer.style.visibility = 'hidden'
    outer.style.overflow = 'scroll' // forcing scrollbar to appear
    outer.style.msOverflowStyle = 'scrollbar' // needed for WinJS apps
    document.body.appendChild(outer)

    // Creating inner element and placing it in the container
    const inner = document.createElement('div')
    outer.appendChild(inner)

    // Calculating difference between container's full width and the child width
    const scrollbarWidth = outer.offsetWidth - inner.offsetWidth

    // Removing temporary elements from the DOM
    outer.parentNode.removeChild(outer)

    return scrollbarWidth
}
