import { html } from 'lit'

import { QrcgModal } from '../../ui/qrcg-modal'

class QRCGSubscriptionModal extends QrcgModal {
    static get properties() {
        return {
            title: {},
            message: {},
            affirmativeText: {},
            negativeText: {},
            link: {},
        }
    }

    renderTitle() {
        return this.title
    }

    renderBody() {
        return this.message
    }

    renderActions() {
        return html`
            <qrcg-button transparent modal-negative slot="actions"
                >${this.negativeText}</qrcg-button
            >
            <qrcg-button modal-affirmative href=${this.link} slot="actions"
                >${this.affirmativeText}</qrcg-button
            >
        `
    }
}

export async function showSubscriptionModal({
    title = 'Your plan is expired',
    message = 'Subscribe now to enjoy uninterrupted services.',
    affirmativeText = 'Subscribe',
    negativeText = 'Cancel',
    link = '/pricing-plans',
} = {}) {
    const modal = new QRCGSubscriptionModal()

    modal.title = title

    modal.message = message

    modal.affirmativeText = affirmativeText

    modal.negativeText = negativeText

    modal.link = link

    document.body.appendChild(modal)

    await new Promise((resolve) => setTimeout(resolve, 0))

    return modal.open()
}

window.customElements.define('qrcg-subscription-modal', QRCGSubscriptionModal)
