import { isEmpty, loadStoredJson, nullOrUndefined, storeJson } from './helpers'

const localStorageKey = 'translate::db'

function getKey(key, rest) {
    if (key instanceof Array) {
        key = key
            .map((part, i) => {
                return part + (nullOrUndefined(rest[i]) ? '' : rest[i])
            })
            .join('')
    }

    return key
}

function cacheKey(key, rest) {
    key = getKey(key, rest)

    if (typeof key === 'object') {
        console.error('key is object, expected type is string', key)
    }

    const language = loadStoredJson(localStorageKey) || {}

    language[key] = ''

    storeJson(language, localStorageKey)
}

// eslint-disable-next-line
export const t = (key, ...rest) => {
    cacheKey(key, rest)

    // const language = loadStoredJson(localStorageKey)

    key = getKey(key, rest)

    const value =
        !window.QRCG_TRANSLATION || isEmpty(window.QRCG_TRANSLATION[key])
            ? key
            : window.QRCG_TRANSLATION[key]

    return value
}

let passphrase = ''

let handler

document.addEventListener('keypress', function (e) {
    passphrase += e.key

    if (passphrase === 'downloadtranslate12') {
        download('language.json', localStorage[localStorageKey])
    }

    clearTimeout(handler)

    handler = setTimeout(() => {
        passphrase = ''
    }, 1000)
})

function download(filename, text) {
    var element = document.createElement('a')
    element.setAttribute(
        'href',
        'data:text/plain;charset=utf-8,' + encodeURIComponent(text)
    )
    element.setAttribute('download', filename)

    element.style.display = 'none'
    document.body.appendChild(element)

    element.click()

    document.body.removeChild(element)
}
