import { LitElement, html, css } from 'lit'
import { isSuperAdmin, loadUser, logout } from '../core/auth'
import { get } from '../core/helpers'
import { currentPlan } from '../core/subscription/logic'
import { t } from '../core/translate'

export class QrcgDashboardSidebarAccount extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
                background-color: var(--primary-0);
                color: white;
                text-align: center;
            }

            .container {
                background-color: rgba(0, 0, 0, 0.2);
                padding: 1.5rem 1rem 1rem 1rem;
                box-sizing: border-box;
            }

            .account-container {
                margin-top: 1rem;
                border-radius: 0.5rem;
                display: flex;
                background-color: var(--primary-0);
                padding: 0.5rem 1rem;
                align-items: center;
                justify-content: space-between;
            }

            .email {
                overflow: hidden;
                display: block;
                text-overflow: ellipsis;
                font-size: 0.8rem;
            }

            .account-container.trial qrcg-button::part(button) {
                background-color: var(--accent-0);
                color: black;
            }

            .account-container.normal-account qrcg-button::part(button) {
                background-color: white;
                color: black;
            }
        `,
    ]

    static get properties() {
        return {
            user: { type: Object },
            plan: { type: Object },
        }
    }

    connectedCallback() {
        super.connectedCallback()
        this.user = loadUser()
        try {
            this.plan = currentPlan()
        } catch (ex) {
            //
        }
    }

    renderTrial() {
        return html`
            <div class="account-container trial">
                <span>${t`Trial`}</span>
                <qrcg-button href="/pricing-plans">${t`Upgrade`}</qrcg-button>
            </div>
        `
    }

    renderAccountBox() {
        let text = this.plan?.name

        if (isSuperAdmin()) {
            text = t(this.user.roles[0].name)
        }

        return html`
            <div class="account-container normal-account">
                <span>${text}</span>
                <qrcg-button @click=${logout}>${t`Logout`}</qrcg-button>
            </div>
        `
    }

    renderAccountButton() {
        if (get(this.plan, 'is_trial') && !isSuperAdmin()) {
            return this.renderTrial()
        }

        return this.renderAccountBox()
    }

    render() {
        return html`
            <div class="container">
                <span class="email">${this.user.email}</span>
                ${this.renderAccountButton()}
            </div>
        `
    }
}

customElements.define(
    'qrcg-dashboard-sidebar-account',
    QrcgDashboardSidebarAccount
)
