import { html } from 'lit'
import { QRCGInstallPage } from './qrcg-install-page'

export class QrcgInstallMail extends QRCGInstallPage {
    renderTitle() {
        return 'Mail Setup'
    }

    getBackLink() {
        return '/install/super-user'
    }

    isLast() {
        return true
    }

    renderWarning() {
        return html`This is final step, make sure all details are correct, you
            will have <b>no longer access</b> to the installation wizard after
            completing this step.`
    }

    getNextLink() {
        return null
    }

    verifyLink() {
        return 'install/verify-mail'
    }

    renderHelp() {
        return `    
            We will send a test email to the super user email provided in previous step.
        `
    }

    verificationFailedMessage() {
        return 'Cannot connect to mail server...'
    }

    verificationSuccessMessage() {
        return 'Mail server connection works...'
    }

    envVariables() {
        return [
            { key: 'MAIL_HOST', name: 'SMTP Host' },
            { key: 'MAIL_PORT', name: 'SMTP Port' },
            { key: 'MAIL_USERNAME', name: 'SMTP User Name' },
            { key: 'MAIL_PASSWORD', name: 'SMTP Password' },
            { key: 'MAIL_ENCRYPTION', name: 'SMTP Encryption' },
            { key: 'MAIL_FROM_ADDRESS', name: 'SMTP From Address' },
            { key: 'MAIL_FROM_NAME', name: 'SMTP From Name' },
        ]
    }
}

customElements.define('qrcg-install-mail', QrcgInstallMail)
