import { t } from '../core/translate'
import { advancedShapes } from './advanced-shapes'
import { qrShapes } from './qr-shapes'

const features = [
    {
        name: t`Copy QR Code`,
        value: 'qrcode.copy',
    },
]

export function getFeatures() {
    return [
        ...features,
        ...qrShapes.map((shape) => ({
            name: t`Shape: ` + shape.name,
            value: 'shape.' + shape.value,
        })),
        ...advancedShapes.map((shape) => ({
            name: t`Sticker: ` + shape.name,
            value: 'advancedShape.' + shape.value,
        })),
    ]
}
