import { isEmpty } from '../core/helpers'

import { Config } from '../core/qrcg-config'
import { t } from '../core/translate'

export class QRCodeModel {
    constructor(record) {
        for (const key in record) {
            if (Object.hasOwnProperty.call(record, key)) {
                const value = record[key]

                Object.defineProperty(this, key, {
                    value,
                    enumerable: true,
                })
            }
        }
    }

    getFileUrl(type) {
        const fileName = `${this.file_name}.${type}`

        const updated = new Date(this.updated_at).getTime()

        return `${Config.get('app.url')}/${Config.get(
            'qrcode.storage_path'
        )}/${fileName}?v=${updated}`
    }

    getEditLink() {
        return `/dashboard/qrcodes/edit/${this.id}`
    }

    getStatsLink() {
        return `/dashboard/qrcodes/stats/${this.id}`
    }

    getDate(key) {
        const date = new Date(this[key])

        return date.toLocaleDateString()
    }

    createdAt() {
        return this.getDate('created_at')
    }

    updatedAt() {
        return this.getDate('updated_at')
    }

    getDates() {
        const created = this.createdAt()

        const updated = this.updatedAt()

        return `${t`Created:`} ${created}${
            updated !== created ? ' ' + t`updated: ` + updated : ''
        }`
    }

    isDynamic() {
        return this.type === 'url'
    }

    getName() {
        if (!this.data) {
            return t('no data')
        }

        if (!isEmpty(this.name)) {
            return this.name
        }

        return t('no name')
    }
}
