import { LitElement, html, css } from 'lit'

import { QRCGTitleController } from '../core/qrcg-title-controller'

import '../dashboard/qrcg-dashboard-layout'

import './qrcg-qrcode-form'

class QRCGQRCodeFormPage extends LitElement {
    titleController = new QRCGTitleController(this)

    static get styles() {
        return css`
            :host {
                display: block;
            }
        `
    }

    render() {
        return html`
            <qrcg-dashboard-layout>
                <span slot="title">${this.titleController.pageTitle}</span>
                <div slot="content">
                    <qrcg-qrcode-form></qrcg-qrcode-form>
                </div>
            </qrcg-dashboard-layout>
        `
    }
}

window.customElements.define('qrcg-qrcode-form-page', QRCGQRCodeFormPage)
