import { LitElement, css, html } from 'lit'

import { QRCGTitleController } from '../core/qrcg-title-controller'

import './qrcg-qrcode-list'

import '../ui/qrcg-button'
import { t } from '../core/translate'

class QRCGQRCodeListPage extends LitElement {
    titleController = new QRCGTitleController(this)

    static get styles() {
        return css`
            :host {
                display: block;
            }
        `
    }

    render() {
        return html`
            <qrcg-dashboard-layout>
                <span slot="title">${this.titleController.pageTitle}</span>
                <qrcg-button slot="header-actions" href="/dashboard/qrcodes/new"
                    >${t`Create`}</qrcg-button
                >
                <div slot="content">
                    <qrcg-qrcode-list></qrcg-qrcode-list>
                </div>
            </qrcg-dashboard-layout>
        `
    }
}

window.customElements.define('qrcg-qrcode-list-page', QRCGQRCodeListPage)
