import { LitElement, html, css } from 'lit'

import '../dashboard/qrcg-dashboard-layout'

import './qrcg-subscription-form'

import { QRCGTitleController } from '../core/qrcg-title-controller'

export class QrcgSubscriptionFormPage extends LitElement {
    titleController = new QRCGTitleController(this)

    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    render() {
        return html`
            <qrcg-dashboard-layout>
                <span slot="title">${this.titleController.pageTitle}</span>
                <qrcg-subscription-form slot="content"></qrcg-subscription-form>
            </qrcg-dashboard-layout>
        `
    }
}
customElements.define('qrcg-subscription-form-page', QrcgSubscriptionFormPage)
