import { LitElement, html, css } from 'lit'

import { QRCGTitleController } from '../core/qrcg-title-controller'
import { t } from '../core/translate'

import '../dashboard/qrcg-dashboard-layout'

import './qrcg-subscription-list'

export class QrcgSubscriptionListPage extends LitElement {
    titleController = new QRCGTitleController(this)

    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    connectedCallback() {
        super.connectedCallback()
        this.titleController.pageTitle = t('Subscriptions')
    }

    render() {
        return html`
            <qrcg-dashboard-layout>
                <span slot="title">${this.titleController.pageTitle}</span>
                <qrcg-button
                    slot="header-actions"
                    href="/dashboard/subscriptions/new"
                    >${t`Create`}</qrcg-button
                >
                <qrcg-subscription-list slot="content"></qrcg-subscription-list>
            </qrcg-dashboard-layout>
        `
    }
}
customElements.define('qrcg-subscription-list-page', QrcgSubscriptionListPage)
