import { LitElement, html, css } from 'lit'
import { QRCGTitleController } from '../core/qrcg-title-controller'

import '../dashboard/qrcg-dashboard-layout'

import './qrcg-subscription-plan-form'

export class QrcgSubscriptionPlanFormPage extends LitElement {
    titleController = new QRCGTitleController(this)

    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    render() {
        return html`
            <qrcg-dashboard-layout>
                <span slot="title">${this.titleController.pageTitle}</span>
                <qrcg-subscription-plan-form
                    slot="content"
                ></qrcg-subscription-plan-form>
            </qrcg-dashboard-layout>
        `
    }
}
customElements.define(
    'qrcg-subscription-plan-form-page',
    QrcgSubscriptionPlanFormPage
)
