import { Config } from '../core/qrcg-config'
import { QRCGDashboardList } from '../dashboard/qrcg-dashboard-list'

export class QrcgSubscriptionPlanList extends QRCGDashboardList {
    constructor() {
        super({
            baseRoute: 'subscription-plans',
            singularRecordName: 'Subscription Plan',
            frontendFormUrl: null,
        })
    }

    static listColumns = [
        { key: 'name', label: 'Name' },
        { key: 'active_price', label: 'Price' },
        { key: 'number_of_dynamic_qrcodes', label: 'Number of QR Codes' },
        { key: 'number_of_scans', label: 'Scans' },
        { key: 'updated_at', label: 'Updated' },

        { key: 'actions', label: 'Actions', width: '7rem' },
    ]

    cellContentRenderer(row, column) {
        switch (column.key) {
            case 'active_price':
                if (typeof row.active_price == 'object') return row.active_price
                else {
                    if (Config.get('app.wplus_integration_enabled')) {
                        if (row.frequency === 'YEAR') {
                            return row.monthly_price
                        } else {
                            return row.price
                        }
                    } else {
                        return row.monthly_price
                    }
                }

            default:
                return super.cellContentRenderer(row, column)
        }
    }
}
customElements.define('qrcg-subscription-plan-list', QrcgSubscriptionPlanList)
