import { LitElement, html, css } from 'lit'

import '../core/qrcg-protected-route'

import './qrcg-subscription-plan-form-page'

import './qrcg-subscription-plan-list-page'

import '../ui/qrcg-pricing-table'

export class QrcgSubscriptionPlanRouter extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    render() {
        return html`
            <qrcg-route route="/dashboard/pricing$">
                <template>
                    <qrcg-pricing-table></qrcg-pricing-table>
                </template>
            </qrcg-route>

            <qrcg-protected-route
                route="/dashboard/subscription-plans$"
                permission="subscription-plan.list-all"
            >
                <template>
                    <qrcg-subscription-plan-list-page></qrcg-subscription-plan-list-page>
                </template>
            </qrcg-protected-route>
            <qrcg-protected-route
                route="/dashboard/subscription-plans/new|/dashboard/subscription-plans/edit/(?<id>\\d+)"
                permission="subscription-plan.store"
            >
                <template>
                    <qrcg-subscription-plan-form-page></qrcg-subscription-plan-form-page>
                </template>
            </qrcg-protected-route>
        `
    }
}

customElements.define(
    'qrcg-subscription-plan-router',
    QrcgSubscriptionPlanRouter
)
