import { LitElement, css } from 'lit'

import { QRCGTitleController } from '../core/qrcg-title-controller'

import { QrcgDashboardBreadcrumbs } from '../dashboard/qrcg-dashboard-breadcrumbs'

export class QrcgSystemPage extends LitElement {
    title = new QRCGTitleController(this)

    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    connectedCallback() {
        super.connectedCallback()

        window.addEventListener(
            'qrcg-router:location-changed',
            this.onLocationChanged
        )

        this.updateNavigation()
    }

    disconnectedCallback() {
        super.disconnectedCallback()

        window.removeEventListener(
            'qrcg-router:location-changed',
            this.onLocationChanged
        )
    }

    pageTitle() {
        return 'Default title'
    }

    updateTitle() {
        this.title.pageTitle = this.pageTitle()
    }

    breadcrumbs() {
        const pathLinks =
            QrcgDashboardBreadcrumbs.buildBreadcrumbFromCurrentPath()

        return pathLinks
    }

    updateBreadcumbs() {
        QrcgDashboardBreadcrumbs.setLinks(this.breadcrumbs())
    }

    onLocationChanged = async () => {
        await new Promise((resolve) => setTimeout(resolve, 0))

        this.updateNavigation()
    }

    updateNavigation = () => {
        this.updateTitle()
        this.updateBreadcumbs()
    }
}
