import { html, css } from 'lit'

import { t } from '../core/translate'

import { QrcgSystemPage } from './qrcg-system-page'

import './qrcg-system-settings-form/appearance'
import './qrcg-system-settings-form/general'
import './qrcg-system-settings-form/logo-favicon'
import './qrcg-system-settings-form/integrations'
import './qrcg-system-settings-form/menus'
import './qrcg-system-settings-form/pages'

export class QrcgSystemSettingsForm extends QrcgSystemPage {
    static styles = [
        css`
            :host {
                display: block;
                padding: 0.1rem;
            }
        `,
    ]

    pageTitle() {
        return t('System Settings')
    }

    render() {
        return html`
            <nav class="tabs">
                <qrcg-tab tab-id="general" active> ${t`General`} </qrcg-tab>
                <qrcg-tab tab-id="appearance"> ${t`Appearance`} </qrcg-tab>
                <qrcg-tab tab-id="logo-favicon">
                    ${t`Logo & Favicon`}
                </qrcg-tab>
                <qrcg-tab tab-id="integrations"> ${t`Integrations`} </qrcg-tab>
                <qrcg-tab tab-id="menus"> ${t`Menus`} </qrcg-tab>
                <qrcg-tab tab-id="pages"> ${t`Pages`} </qrcg-tab>
            </nav>

            <qrcg-tab-content tab-id="general" active>
                <template>
                    <qrcg-system-settings-form-general></qrcg-system-settings-form-general>
                </template>
            </qrcg-tab-content>

            <qrcg-tab-content tab-id="appearance">
                <template>
                    <qrcg-system-settings-form-appearance></qrcg-system-settings-form-appearance>
                </template>
            </qrcg-tab-content>

            <qrcg-tab-content tab-id="logo-favicon">
                <template>
                    <qrcg-system-settings-form-logo-favicon></qrcg-system-settings-form-logo-favicon>
                </template>
            </qrcg-tab-content>

            <qrcg-tab-content tab-id="integrations">
                <template>
                    <qrcg-system-settings-form-integrations></qrcg-system-settings-form-integrations>
                </template>
            </qrcg-tab-content>

            <qrcg-tab-content tab-id="menus">
                <template>
                    <qrcg-system-settings-form-menus></qrcg-system-settings-form-menus>
                </template>
            </qrcg-tab-content>

            <qrcg-tab-content tab-id="pages">
                <template>
                    <qrcg-system-settings-form-pages></qrcg-system-settings-form-pages>
                </template>
            </qrcg-tab-content>
        `
    }
}
customElements.define('qrcg-system-settings-form', QrcgSystemSettingsForm)
