import { html, css } from 'lit'
import { t } from '../../core/translate'
import { QrcgSystemSettingsFormBase } from './base'

export class Appearance extends QrcgSystemSettingsFormBase {
    static styles = [
        super.styles,
        css`
            :host {
                display: block;
            }
        `,
    ]

    renderForm() {
        return html`
            <section>
                <h2 class="section-title">${t`Appearance`}</h2>

                <qrcg-color-picker name="theme.primary_0"
                    >${t`Primary Color 0`}</qrcg-color-picker
                >

                <qrcg-color-picker name="theme.primary_1">
                    ${t`Primary Color 1`}
                </qrcg-color-picker>

                <qrcg-color-picker name="theme.accent_0">
                    ${t`Accent Color 0`}
                </qrcg-color-picker>

                <qrcg-color-picker name="theme.accent_1">
                    ${t`Accent Color 1`}
                </qrcg-color-picker>

                <qrcg-balloon-selector
                    name="theme.input_placeholder_font_style"
                    .options=${[
                        { value: 'italic', name: t`Italic` },
                        { value: 'normal', name: t`Normal` },
                    ]}
                >
                    ${t`Input placeholder font style`}
                </qrcg-balloon-selector>
            </section>
        `
    }
}

customElements.define('qrcg-system-settings-form-appearance', Appearance)
