import { html, css } from 'lit'
import { t } from '../../core/translate'
import { QrcgSystemSettingsFormBase } from './base'

export class QrcgSystemSettingsFormGeneral extends QrcgSystemSettingsFormBase {
    static styles = [
        super.styles,
        css`
            :host {
                display: block;
            }
        `,
    ]

    renderForm() {
        return html`
            <section>
                <h2 class="section-title">${t`General Settings`}</h2>
                <qrcg-form-comment label="">
                    <p>
                        ${t`If you would like to use another content management system for the frontned, please enter the URL here.`}
                        ${t`Once the URL is specified, the frontend of the script will be disabled.`}
                        ${t`Leave empty to keep using the default frontend.`}
                    </p>
                    <p>
                        ${t`Frontend pages include: Home page, About, Contact, Blog, Single blog post etc...`}
                    </p>
                </qrcg-form-comment>

                <qrcg-input name="app.name"> ${t`App name`} </qrcg-input>
                <qrcg-input name="frontend.slogan">
                    ${t`App slogan`}
                </qrcg-input>

                <qrcg-textarea name="homepage.meta_description" maxLength="160">
                    ${t`Home page meta description`}
                </qrcg-textarea>

                <qrcg-input
                    name="app.frontend_custom_url"
                    placeholder="https://your-domain.com"
                >
                    ${t`Frontend custom URL`}
                </qrcg-input>

                <qrcg-balloon-selector
                    name="app.frontend_links"
                    .options=${[
                        {
                            name: t`Enabled`,
                            value: 'enabled',
                        },
                        {
                            name: t`Disabled`,
                            value: 'disabled',
                        },
                    ]}
                >
                    ${t`Frontend Links`}
                    <div slot="instructions">
                        ${t`Useful if you have a custom frontend, and you want your clients to stay in the dashboard area. This will remove `}
                        <strong>${t`Contact`}</strong>
                        ${t`menu link from the client dashboard sidebar.`}
                        <strong>${t`Home page link`}</strong>
                        ${t`below login form will be removed as well.`}
                        ${t`Default is Enabled.`}
                    </div>
                </qrcg-balloon-selector>

                <qrcg-balloon-selector
                    name="app.after_logout_action"
                    .options=${[
                        {
                            value: 'redirect_to_login_page',
                            name: t`Redirect to login page`,
                        },
                        {
                            value: 'redirect_lo_home_page',
                            name: t`Redirect to home page`,
                        },
                    ]}
                >
                    ${t`After logout action`}
                </qrcg-balloon-selector>

                <qrcg-balloon-selector
                    name="app.new_user_registration"
                    .options=${[
                        {
                            value: 'enabled',
                            name: t`Enabled`,
                        },
                        {
                            value: 'disabled',
                            name: t`Disabled`,
                        },
                    ]}
                >
                    ${t`New user registration`}
                    <div slot="instructions">${t`Default is Enabled`}</div>
                </qrcg-balloon-selector>
            </section>
        `
    }
}

customElements.define(
    'qrcg-system-settings-form-general',
    QrcgSystemSettingsFormGeneral
)
