import { html, css } from 'lit'
import { t } from '../../core/translate'
import { QrcgSystemSettingsFormBase } from './base'

import '../../common/qrcg-menu-input'

export class QrcgSystemSettingsFormMenus extends QrcgSystemSettingsFormBase {
    static styles = [
        super.styles,
        css`
            :host {
                display: block;
            }
        `,
    ]

    renderForm() {
        return html`
            <section>
                <h2 class="section-title">${t`Dashboard Menu (Clients)`}</h2>
                <qrcg-form-comment label="">
                    <p>
                        ${t`Add extra links to display on the client dashboard sidebar`}
                    </p>
                </qrcg-form-comment>

                <qrcg-menu-input
                    name="app.dashboard-client-menu"
                ></qrcg-menu-input>
            </section>
        `
    }
}

customElements.define(
    'qrcg-system-settings-form-menus',
    QrcgSystemSettingsFormMenus
)
