import { LitElement, html, css } from 'lit'
import { QRCGTitleController } from '../core/qrcg-title-controller'

import './qrcg-system-settings-form'

export class QrcgSystemSettingsPage extends LitElement {
    titleController = new QRCGTitleController(this)

    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    render() {
        return html`
            <qrcg-dashboard-layout>
                <span slot="title"> ${this.titleController.pageTitle} </span>

                <qrcg-system-settings-form
                    slot="content"
                ></qrcg-system-settings-form>
            </qrcg-dashboard-layout>
        `
    }
}
customElements.define('qrcg-system-settings-page', QrcgSystemSettingsPage)
