import { QRCGFormController } from '../core/qrcg-form-controller'

export class QRCGTypeFormController extends QRCGFormController {
    hostConnected() {
        super.hostConnected()

        this.submitOnInputIfNeeded()

        this.showSubmitButtonIfNeeded()
    }

    submitOnInputIfNeeded() {
        this.host.addEventListener('on-input', () => {
            if (this.host.submitOnInput) {
                setTimeout(() => {
                    this.fireSubmit()
                }, 0)
            }
        })
    }

    async hostUpdate() {
        super.hostUpdate()
        this.showSubmitButtonIfNeeded()
    }

    async showSubmitButtonIfNeeded() {
        await new Promise((resolve) => setTimeout(() => resolve(), 0))

        if (this.host.showSubmitButton) {
            const button = this.host.renderRoot.querySelector(
                'qrcg-button[type=submit]'
            )

            if (button) {
                button.hidden = false
            }
        }
    }
}
