import { LitElement, html, css } from 'lit'

import {
    Chart,
    LinearScale,
    BarController,
    CategoryScale,
    BarElement,
} from 'chart.js'

import { isEmpty } from '../core/helpers'

Chart.register(LinearScale)
Chart.register(BarController)
Chart.register(CategoryScale)
Chart.register(BarElement)

export class QrcgStats extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
            }
        `,
    ]

    static get properties() {
        return {
            data: { type: Array },
        }
    }

    constructor() {
        super()

        this.data = [
            {
                label: '1/1/2000',
                number: 10,
                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                borderColor: 'rgba(255, 99, 132, 1)',
            },
            {
                label: '2/1/2000',
                number: 20,
                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                borderColor: 'rgba(255, 99, 132, 1)',
            },
            {
                label: '3/1/2000',
                number: 40,
                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                borderColor: 'rgba(255, 99, 132, 1)',
            },
            {
                label: '4/1/2000',
                number: 10,
                backgroundColor: 'rgba(255, 99, 132, 0.2)',
                borderColor: 'rgba(255, 99, 132, 1)',
            },
        ]
    }

    firstUpdated() {}

    connectedCallback() {
        super.connectedCallback()
    }

    disconnectedCallback() {
        super.disconnectedCallback()
    }

    updated(changed) {
        if (changed.has('data')) {
            if (!isEmpty(this.data)) {
                this.initChart()
            }
        }
    }

    initChart() {
        const ctx = this.renderRoot.getElementById('myChart').getContext('2d')

        new Chart(ctx, {
            type: 'bar',
            data: {
                labels: this.data.map((record) => record.label),
                datasets: [
                    {
                        data: this.data.map((r) => r.number),
                        backgroundColor: this.data.map(
                            (r) => r.backgroundColor
                        ),
                        borderColor: this.data.map((r) => r.borderColor),
                        borderWidth: 1,
                    },
                ],
            },
            options: {
                scales: {
                    y: {
                        beginAtZero: true,
                    },
                },
            },
        })
    }

    render() {
        return html` <canvas id="myChart" width="400" height="250"></canvas> `
    }
}

customElements.define('qrcg-chart', QrcgStats)
