import { LitElement, html, css } from 'lit'

import '../ui/qrcg-text-div'

export class QrcgFaqContent extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
                max-height: 0;
                overflow: hidden;
                color: var(--gray-2);
                transition: max-height 0.3s ease-in-out;
                margin-top: 1rem;
            }
        `,
    ]

    render() {
        return html`
            <qrcg-text-dev>
                <slot></slot>
            </qrcg-text-dev>
        `
    }
}
customElements.define('qrcg-faq-content', QrcgFaqContent)
