import { LitElement, html, css } from 'lit'

import { mdiChevronDown } from '@mdi/js'

export class QrcgFaqTitle extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
                margin: 1rem 0 0 0;
            }

            qrcg-h3 {
                border-bottom: 2px solid var(--gray-0);
                cursor: pointer;
                text-transform: capitalize;
                padding-bottom: 0.5rem;
                margin: 0;
                display: flex;
                justify-content: space-between;
                align-items: center;
            }

            qrcg-icon {
                color: var(--gray-1);
            }

            :host(.active) qrcg-icon {
                transform: scaleY(-1);
            }

            :host(:hover) h3 {
                border-bottom: 2px solid var(--gray-1);
            }

            :host(:hover) qrcg-icon {
                color: var(--gray-2);
            }
        `,
    ]

    render() {
        return html`
            <qrcg-h3>
                <span>
                    <slot></slot>
                </span>
                <qrcg-icon
                    mdi-icon=${mdiChevronDown}
                    width="2rem"
                    height="2rem"
                ></qrcg-icon>
            </qrcg-h3>
        `
    }
}
customElements.define('qrcg-faq-title', QrcgFaqTitle)
