import { LitElement, html, css } from 'lit'

export class QrcgFooter extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
                background-color: var(--primary-0);
                color: white;
                padding: 2rem 1rem;
                text-align: center;
            }

            .social-row {
                display: flex;
                align-items: center;
                justify-content: center;
                margin-bottom: 1rem;
                overflow: hidden;
            }
            .social-inner {
                display: flex;
                align-items: center;
                margin-right: -1rem;
            }

            ::slotted(qrcg-social-link) {
                margin-right: 1rem;
            }

            .links {
                display: flex;
                justify-content: center;
                margin-bottom: 1rem;
            }

            [name='links']::slotted(a) {
                color: white;
                display: block;
                margin: 0.5rem;
            }
        `,
    ]

    render() {
        return html`
            <footer>
                <slot name="summary"></slot>
                <div class="social-row">
                    <div class="social-inner">
                        <slot name="social"></slot>
                    </div>
                </div>
                <div class="links">
                    <slot name="links"></slot>
                </div>

                <slot name="copy"></slot>
            </footer>
        `
    }
}
customElements.define('qrcg-footer', QrcgFooter)
