import { LitElement, html, css } from 'lit'

export class QrcgOnOffBadge extends LitElement {
    static styles = [
        css`
            :host {
                display: inline-block;
                user-select: none;
                -webkit-user-select: none;
            }

            .enabled-badge {
                display: inline-block;
                border-radius: 0.1rem;
                padding: 0.25rem 0.65rem;
                text-transform: uppercase;
                font-size: 0.7rem;
            }
            .enabled-badge.yes {
                background-color: var(--success-0);
                color: white;
            }
            .enabled-badge.no {
                background-color: var(--gray-2);
                color: white;
            }
        `,
    ]

    static get properties() {
        return {
            onText: {
                attribute: 'on-text',
            },
            offText: {
                attribute: 'off-text',
            },
            enabled: { type: Boolean },
        }
    }

    render() {
        return html` <div class="enabled-badge ${this.enabled ? 'yes' : 'no'}">
            ${this.enabled ? this.onText : this.offText}
        </div>`
    }
}
customElements.define('qrcg-on-off-badge', QrcgOnOffBadge)
