import {
    mdiFacebook,
    mdiLinkedin,
    mdiTwitter,
    mdiInstagram,
    mdiWhatsapp,
    mdiYoutube,
    mdiVimeo,
    mdiSnapchat,
} from '@mdi/js'
import { LitElement, html, css } from 'lit'
import './qrcg-icon'

const telegramIcon = `
<svg width="20px" height="20px" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg"><path fill="currentColor" d="m12 0c-6.627 0-12 5.373-12 12s5.373 12 12 12 12-5.373 12-12c0-6.627-5.373-12-12-12zm5.894 8.221-1.97 9.28c-.145.658-.537.818-1.084.508l-3-2.21-1.446 1.394c-.14.18-.357.295-.6.295-.002 0-.003 0-.005 0l.213-3.054 5.56-5.022c.24-.213-.054-.334-.373-.121l-6.869 4.326-2.96-.924c-.64-.203-.658-.64.135-.954l11.566-4.458c.538-.196 1.006.128.832.941z"/></svg>`

export class QrcgSocialLink extends LitElement {
    static styles = [
        css`
            :host {
                display: block;
                position: relative;
            }

            a {
                position: absolute;
                top: 0;
                right: 0;
                left: 0;
                bottom: 0;
            }
        `,
    ]

    static get properties() {
        return {
            type: {},
            href: {},
        }
    }

    get types() {
        return [
            {
                name: 'linkedin',
                icon: mdiLinkedin,
            },
            {
                name: 'twitter',
                icon: mdiTwitter,
            },
            {
                name: 'telegram',
                svgIcon: telegramIcon,
            },
            {
                name: 'facebook',
                icon: mdiFacebook,
            },
            {
                name: 'instagram',
                icon: mdiInstagram,
            },
            {
                name: 'whatsapp',
                icon: mdiWhatsapp,
            },
            {
                name: 'youtube',
                icon: mdiYoutube,
            },
            {
                name: 'vimeo',
                icon: mdiVimeo,
            },
            {
                name: 'snapchat',
                icon: mdiSnapchat,
            },
        ]
    }

    matchTypeFromHref() {
        return this.types.find((t) => this.href.match(t.name))
    }

    willUpdate(changed) {
        if (changed.has('href') && this.href) {
            this.type = this.matchTypeFromHref()
        }
    }

    render() {
        if (!this.type) return

        if (this.type.icon)
            return html`
                <qrcg-icon mdi-icon=${this.type.icon}></qrcg-icon>
                <a href=${this.href} target="_blank"></a>
            `

        return html`
            <qrcg-icon icon=${this.type.svgIcon}></qrcg-icon>
            <a href=${this.href} target="_blank"></a>
        `
    }
}

customElements.define('qrcg-social-link', QrcgSocialLink)
