import { styled } from '../core/helpers'

export class QRCGTextDiv extends HTMLDivElement {
    constructor() {
        super()

        const shadowRoot = this.attachShadow({ mode: 'open' })

        shadowRoot.innerHTML = `<style> ${this.makeStyles()} </style><slot></slot>`
    }

    makeStyles() {
        const fontSize = `1rem`

        const lineHeight = `2rem`

        const style = styled`
                :host {
                    display: block;
                    font-size: ${fontSize};
                    line-height: ${lineHeight};

                }
            `

        return style
    }
}

customElements.define('qrcg-text-div', QRCGTextDiv)
