<?php

namespace App\Http\Controllers;

use App\Events\SubscriptionVerified;
use App\Models\Subscription;
use App\Models\SubscriptionPlan;
use App\Repositories\StripePaymentGateway;
use Stripe\Checkout\Session as CheckoutSession;

class CheckoutController extends Controller
{
    public function stripeCheckout(Subscription $subscription, StripePaymentGateway $stripe)
    {
        return [
            'url' => $stripe->generateCheckoutUrl($subscription)
        ];
    }

    public function stripeVerifyCheckoutSession($checkoutSessionId, StripePaymentGateway $stripe)
    {
        $session = $stripe->getCheckoutSession($checkoutSessionId);

        if (!$session || $session->payment_status !== 'paid') {
            return response()->json([
                'error' => t('Invalid session data'),
            ], 422);
        }

        $subscriptionId = $session->client_reference_id;

        $subscription = Subscription::findOrFail($subscriptionId);

        $subscription->stripe_id = $session->subscription;

        $subscription->save();

        event(new SubscriptionVerified($subscription));

        return [
            'success' => true
        ];
    }
}
