<?php

namespace App\Http\Controllers;

use App\Models\PaypalPaymentGateway;
use App\Models\Transaction;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class PaypalWebhook extends Controller
{
    /**
     * Handle the incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return \Illuminate\Http\Response
     */
    public function __invoke(Request $request)
    {
        $type = $request->event_type;

        switch ($type) {
            case 'PAYMENT.SALE.COMPLETED':

                $transaction = new Transaction();
                $transaction->subscription_id = $request->resource['custom'];
                $transaction->amount = $request->resource['amount']['total'];
                $transaction->currency = $request->resource['amount']['currency'];
                $transaction->payment_gateway_id = PaypalPaymentGateway::id();
                $transaction->status = Transaction::STATUS_SUCESS;
                $transaction->paypal_payment_id = $request->resource['id'];
                $transaction->save();
                $transaction->refresh();
                break;
            case 'PAYMENT.SALE.DENIED':
                $transaction = new Transaction();
                $transaction->subscription_id = $request->resource['custom'];
                $transaction->amount = $request->resource['amount']['total'];
                $transaction->currency = $request->resource['amount']['currency'];
                $transaction->payment_gateway_id = PaypalPaymentGateway::id();
                $transaction->status = Transaction::STATUS_FAILED;
                $transaction->paypal_payment_id = $request->resource['id'];
                $transaction->save();
                $transaction->refresh();
            default:
                # code...
                break;
        }


        return 'OK';
    }
}
