<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;


class SaveSubscriptionPlanRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     *
     * @return bool
     */
    public function authorize()
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array
     */
    public function rules()
    {
        return [
            'name' => 'required',
            'monthly_price' => 'required_if:frequency,YEAR|numeric',
            'price' => 'required_if:frequency,ONE_TIME|numeric',
            'number_of_dynamic_qrcodes' => 'required|integer|min:0',
            'number_of_scans' => 'required|integer|min:0'
        ];
    }
}
