<?php

namespace App\Http\Resources;

use App\Models\PaymentGateway;
use App\Models\PaypalPaymentGateway;
use App\Models\StripePaymentGatewayModel;
use Illuminate\Http\Resources\Json\JsonResource;
use Illuminate\Support\Facades\Log;

class PaymentGatewayResource extends JsonResource
{
    private $defaultFields = ['id', 'name', 'mode', 'enabled', 'slug'];

    public function __construct(PaymentGateway $resource)
    {
        $this->resource = $resource->make();
    }

    private function paymentGatewayModel()
    {
        $p = new PaymentGateway();

        $p->forceFill($this->resource->toArray());

        return $p;
    }

    /**
     * Transform the resource into an array.
     *
     * @param  \Illuminate\Http\Request  $request
     * @return array|\Illuminate\Contracts\Support\Arrayable|\JsonSerializable
     */
    public function toArray($request)
    {
        $this->request = $request;

        return array_merge(
            $this->makeDefaultFields(),
            $this->makePaymentFields()
        );
    }

    private function makePaymentFields()
    {
        return array_reduce(
            $this->resource->payment_fields ?? [],
            function ($arr, $field) {
                if (app()->environment('demo')) {
                    $arr[$field] = 'hidden_in_demo';
                } else if ($this->request->user()->can('update', $this->paymentGatewayModel())) {
                    $arr[$field] = $this->resource->{$field};
                }
                return $arr;
            },
            []
        );
    }

    private function makeDefaultFields()
    {
        $fields = array_merge($this->defaultFields, $this->resource->appends ?? []);

        return array_reduce($fields, function ($arr, $name) {
            $arr[$name] = $this->{$name};
            return $arr;
        }, []);
    }
}
