<?php

namespace App\Interfaces;

use App\Models\Translation;
use Illuminate\Http\Request;

interface TranslationManager
{
    /**
     * Translate the given text into active system wide language. 
     */
    public static function t(string $text);

    public function search(bool $paginate = true);

    public function save($data, ?Translation $translation = null);

    public function delete(Translation $translation);

    public function load(Translation $translation);

    /**
     * Updates the translation file with given @param data
     */
    public function write($data, Translation $translation);

    public function completeness(Translation $trasnlation);

    public function verifyTranslationFile(Translation $translation);

    public function upload(Request $request, Translation $translation);

    public function activate(Translation $translation);

    public static function loadActiveTranslationFile();
}
