<?php

namespace App\Listeners;

use App\Events\Subscribed;

use App\Models\SubscriptionPlan;
use App\Models\SubscriptionStatus;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;

class AssignDefaultSubscriptionStatus
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\SubscriptionCreated  $event
     * @return void
     */
    public function handle(Subscribed $event)
    {
        $defaultPlan = SubscriptionPlan::where('is_trial', true)->first();

        // Trial subscriptions are assigned active status by default
        if ($event->subscription->subscription_plan_id === $defaultPlan->id) {
            return;
        }

        $status = new SubscriptionStatus([
            'subscription_id' => $event->subscription->id,
            'status' => SubscriptionStatus::STATUS_PENDING_PAYMENT
        ]);

        $status->save();
    }
}
