<?php

namespace App\Listeners;

use App\Events\CurrencyEnabled;
use App\Interfaces\CurrencyManager;
use App\Models\PaymentGateway;
use App\Models\SubscriptionPlan;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Support\Facades\Log;

class OnCurrencyEnabled implements ShouldQueue
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(CurrencyEnabled $event)
    {
        foreach (SubscriptionPlan::all() as $plan) {


            if ($plan->is_trial) continue;

            foreach (PaymentGateway::all() as $gateway) {

                $repository = $gateway->make()->resolveRepository();

                if (!$repository) continue;

                try {
                    $repository->saveSubscriptionPlan(
                        $plan,
                        forceSync: true
                    );

                    $plan->saveQuietly();
                    Log::info('OnCurrencyEnabled: Plan details synced with payment gateway, Plan: ' . $plan->name . ' Gateway: ' . $gateway->name);
                } catch (\Throwable $th) {
                    Log::error('Could not save subscription plan ID ' . $th->getMessage());
                    Log::error($th->getTraceAsString());
                }
            }
        }
    }
}
