<?php

namespace App\Listeners;

use App\Events\QRCodeSaved;
use App\Events\ShouldSaveQRCodeVariants;


class OnQRCodeSaved
{
    private QRCodeSaved $event;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\QRCodeSaved  $event
     * @return void
     */
    public function handle(QRCodeSaved $event)
    {
        $this->event = $event;

        if (!$this->shouldRun()) return;

        event(new ShouldSaveQRCodeVariants($event->qrcode));
    }

    private function shouldRun()
    {
        if (app()->runningInConsole() && app()->environment() === 'local') {
            return env('DEV_SAVE_QRCODE_VARIANTS');
        }

        return $this->event->qrcode->wasRecentlyCreated ||
            $this->event->qrcode->wasChanged(['data', 'design']);
    }
}
