<?php

namespace App\Listeners;

use App\Events\SavingSubscriptionPlan;
use App\Interfaces\PaymentGateway;
use App\Models\SubscriptionPlan;
use App\Repositories\PaypalPaymentGateway;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Queue\InteractsWithQueue;


use Illuminate\Support\Facades\Log;

class OnSavingSubscriptionPlan
{
    private SubscriptionPlan $model;

    private $paymentGateways;

    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct(PaymentGateway ...$paymentGateways)
    {
        $this->paymentGateways = $paymentGateways;
    }

    /**
     * Handle the event.
     *
     * @param  \App\Events\SavingSubscriptionPlan  $event
     * @return void
     */
    public function handle(SavingSubscriptionPlan $event)
    {
        $this->model = $event->model;

        if ($this->model->is_trial) {
            return $this->model->resetPaymentGatewayFields();
        }

        if ($this->shouldHandle()) {
            foreach ($this->paymentGateways as $paymentGateway) {
                $paymentGateway->saveSubscriptionPlan($this->model);
            }
        }
    }

    private function shouldHandle()
    {
        $wasRecentlyCreated = $this->model->wasRecentlyCreated;

        $isDirty = $this->model->isDirty(['monthly_price']);

        return $wasRecentlyCreated || $isDirty;
    }
}
