<?php

namespace App\Models;

use App\Events\ConfigChanged;
use Illuminate\Database\Eloquent\Factories\HasFactory;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\Log;

class Config extends Model
{
    use HasFactory;

    public static function boot()
    {
        parent::boot();
    }

    public static function id($key)
    {
        return static::where('key', $key)->first()?->id;
    }

    public static function get($key)
    {
        $value = static::where('key', $key)->first()?->value;

        if ($value)
            $value = json_decode($value);

        return $value;
    }

    public static function set($key, $value)
    {
        $record = static::where('key', $key)->first();

        if (!$record) {
            $record = new static;
            $record->key = $key;
        }

        if ($value)
            $record->value = json_encode($value);
        else
            $record->value = $value;

        $record->save();

        ConfigChanged::fire($key);

        return $record;
    }
}
