<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Str;

class ContentBlock extends Model
{
    use HasFactory;

    protected $fillable = [
        'title',
        'content',
        'position',
        'sort_order',
        'title_alignment',
        'content_alignment',
        'title_color',
        'content_color',
        'background_color',
        'margin',
        'padding',
    ];

    public function contentHtml(): Attribute
    {
        return new Attribute(fn () => Str::markdown($this->content));
    }
}
