<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use Illuminate\Support\Facades\Log;

class QRCodeRedirect extends Model
{
    use HasFactory;

    protected $table = 'qrcode_redirects';

    public function getRouteAttribute()
    {
        return route('qrcode.redirect', ['slug' => $this->slug]);
    }

    public function getDestinationAttribute($value)
    {
        if (preg_match('/^https?/', $value)) return $value;

        return 'http://' . $value;
    }

    public function qrcode()
    {
        return $this->belongsTo(QRCode::class, 'qrcode_id');
    }
}
