<?php

namespace App\Policies;

use App\Models\OfflinePaymentGatewayModel;
use App\Models\Transaction;
use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;

class TransactionPolicy
{
    use HandlesAuthorization;

    public function list(User $user)
    {
        return $user->permitted('transaction.list-all');
    }

    public function approve(User $user, Transaction $transaction)
    {
        return
            $this->source($transaction, OfflinePaymentGatewayModel::SLUG) &&
            $user->permitted('transaction.approve');
    }

    public function reject(User $user, Transaction $transaction)
    {
        return
            $this->source($transaction, OfflinePaymentGatewayModel::SLUG) &&
            $user->permitted('transaction.reject');
    }

    private function source(Transaction $transaction, $slug)
    {
        return $transaction->payment_gateway->slug === $slug;
    }
}
