<?php

namespace App\Policies;

use App\Models\User;
use Illuminate\Auth\Access\HandlesAuthorization;


class UserPolicy extends BasePolicy
{
    use HandlesAuthorization;

    public function list(User $actor)
    {
        return $actor->permitted('user.list-all');
    }

    public function show(User $actor, User $subject)
    {
        return $actor->permitted('user.show-any');
    }

    public function store(User $actor)
    {
        return $actor->permitted('user.store');
    }

    public function update(User $actor, User $subject)
    {
        $this->restrictDemo();

        return $actor->permitted('user.update-any');
    }

    public function destroy(User $actor, User $subject)
    {
        $this->restrictDemo();

        return $actor->permitted('user.destroy-any') && $subject->id != $actor->id;
    }
}
