<?php

namespace App\Providers;


use Illuminate\Support\ServiceProvider;

use App\Support\AppInstaller;

use Illuminate\Database\Eloquent\Model;

use App\Models\Config as ConfigModel;
use App\Interfaces\FileManager;
use App\Models\File;
use App\Support\ContentManager;
use Illuminate\Support\Facades\Config;
use Illuminate\Support\Facades\Log;
use Throwable;

class ConfigServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     *
     * @return void
     */
    public function register()
    {
    }

    /**
     * Bootstrap any application services.
     *
     * @return void
     */
    public function boot()
    {

        $gateways = app()->tagged('paymentGateways');


        foreach ($gateways as $gateway) {
            try {
                $gateway::boot();
            } catch (Throwable $th) {
                Log::error($th->getMessage());
            }
        }

        try {
            $this->bindDatabaseConfigurations();
        } catch (\Throwable $th) {
            /**
             * Boot would fail on docker container build.
             * When executing the command @php artisan package:discover --ansi
             * The database connection won't be ready then.
             */
        }

        if (Config::get('app.url') !== url('/')) {
            Config::set('app.url', url('/'));
        }

        // binds frontend.header_logo_url
        $this->bindFileUrlConfig('frontend.header_logo');

        // binds frontend.header_logo_inverse_url
        $this->bindFileUrlConfig('frontend.header_logo_inverse');
    }

    private function bindFileUrlConfig($configKeyOfFileId)
    {
        try {
            $files = app(FileManager::class);

            if ($fileId = Config::get($configKeyOfFileId)) {

                $file = File::find($fileId);

                if ($file) {
                    Config::set(
                        $configKeyOfFileId . '_url',
                        $files->url($file)
                    );
                }
            }
        } catch (Throwable $th) {
            Log::error('Error while in ConfigServiceProvider::bindFileUrlConfig ' . $th->getMessage(), compact('configKeyOfFileId'));
        }
    }

    private function bindDatabaseConfigurations()
    {
        ConfigModel::all()->each(function ($record) {
            if ($record->value)
                Config::set($record->key, $record->value);
        });
    }
}
