<?php

namespace App\Repositories;

use App\Http\Requests\StoreContentBlockRequest;
use App\Http\Requests\UpdateContentBlockRequest;
use App\Interfaces\ContentBlockManager as ContentBlockManagerInterface;
use App\Interfaces\ModelSearchBuilder;
use App\Models\ContentBlock;
use Illuminate\Support\Facades\Artisan;

class ContentBlockManager implements ContentBlockManagerInterface
{
    private ModelSearchBuilder $search;

    public function __construct(ModelSearchBuilder $search)
    {
        $this->search = $search;
    }

    public function list()
    {
        return $this
            ->search
            ->init(ContentBlock::class, request(), false)
            ->inColumn('title')
            ->inColumn('position')
            ->withQuery(function ($query) {
                $query->orderBy('sort_order', 'asc');
            })
            ->search()
            ->paginate();
    }

    public function get(ContentBlock $block)
    {
        return $block;
    }

    public function store(StoreContentBlockRequest $request)
    {
        $contentBlock = new ContentBlock($request->all());

        $contentBlock->save();

        $this->clearCache();

        return $contentBlock;
    }

    public function update(UpdateContentBlockRequest $request, ContentBlock $block)
    {
        $block->fill($request->all());
        $block->save();
        $this->clearCache();
        return $block;
    }

    private function clearCache()
    {
        Artisan::call('view:clear');
    }

    public function destroy(ContentBlock $block)
    {
        $block->delete();

        return $block;
    }
}
